package com.agilex.healthcare.directscheduling.datalayer;


import com.agilex.healthcare.directscheduling.mdws.connection.MdwsConfiguration;
import com.agilex.healthcare.directscheduling.mdws.connection.SchedulingConnection;
import com.agilex.healthcare.directscheduling.mdws.connection.SchedulingConnectionManager;
import com.agilex.healthcare.directscheduling.mdws.connection.SchedulingConnectionManagerFactory;

import gov.va.vamf.scheduling.direct.datalayer.facility.CustomMessageService;
import gov.va.vamf.scheduling.direct.domain.CustomMessages;
import gov.va.vamf.scheduling.direct.domain.CustomMessage;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Iterator;

public class MdwsSchedulingDataLayer implements InitializingBean {

    @Value("${default.messages.id}")
    String defaultMessagesId;

    @Value("${default.messages.text}")
    String defaultMessagesText;

    private String[] defaultMessageIds;
    private String[] defaultMessageTexts;

    @Autowired
    private CustomMessageService customMessageService;

    @Override
    public void afterPropertiesSet() throws Exception {
        defaultMessageIds = defaultMessagesId.split("\\|");
        defaultMessageTexts = defaultMessagesText.split("\\|");
    }

    protected MdwsConfiguration mdwsConfiguration;

    public MdwsSchedulingDataLayer(MdwsConfiguration mdwsConfiguration) {
        this.mdwsConfiguration = mdwsConfiguration;
    }

    protected SchedulingConnection getAuthenticatedConnection(String siteCode) {

        fillDefaultMessages(siteCode);

        SchedulingConnectionManager connectionManager = SchedulingConnectionManagerFactory.getInstance();
        return connectionManager.getAuthenticatedSiteConnection(mdwsConfiguration);
    }

    private void fillDefaultMessages(String siteCode) {

        CustomMessages customMessages = customMessageService.fetchCustomMessagesBySiteCode(siteCode);

        if (customMessages == null) {
            customMessages = new CustomMessages();
        }

        for (int i = 0; i < defaultMessageIds.length; i++) {
            if (!containsMessageId(defaultMessageIds[i], customMessages)) {

                CustomMessage defaultMessage = new CustomMessage();
                defaultMessage.setSiteCode(siteCode);
                defaultMessage.setMessageId(defaultMessageIds[i]);
                defaultMessage.setMessageText(defaultMessageTexts[i]);

                CustomMessage savedDefaultMessage = customMessageService.saveCustomMessage(defaultMessage);
            }
        }
    }

    private boolean containsMessageId(String messageId, CustomMessages customMessages) {
        Iterator<CustomMessage> customMessagesIterator = customMessages.iterator();

        while (customMessagesIterator.hasNext()) {
            if (messageId.equals(customMessagesIterator.next().getMessageId())) {
                return true;
            }
        }

        return false;
    }
}
